 /******************************************************************************
  *       __   _   _____   _   _        _____   _____   _____                  *
  *      |  \ | | | ____| | | | |      /  ___| /  ___| /  ___/                 *
  *      |   \| | | |__   | | | |      | |     | |     | |___                  *
  *      | |\   | |  __|  | | | |      | |     | |     \___  \                 *
  *      | | \  | | |___  | |_| |      | |___  | |___   ___| |                 *
  *      |_|  \_| |_____| \_____/      \_____| \_____| /_____/                 *
  *                                                                            *
  *                        Blinking Led Example                                *
  ******************************************************************************
  * This is a simple example of MSP430 program. Three different color leds are *
  * toggling one after the other. This example demonstrates the basic way to   *
  * initialize and set registers. Through it you will also know how to compile *
  * the source code and download the binary code to the device.                *
  ******************************************************************************
  * Compiler: msp430-gcc GNU C compiler                                        *
  * Target platform: MSP-430F1611 (can easily be ported to other platforms)    *
  ******************************************************************************
  * Last update: 01/05/2007                                                    *
  ******************************************************************************/

#include "include/include.h"
#include "include/hardware.h"

//-------------------------------------------------------------------------------------------------------
//	int main (void)
//
//	DESCRIPTION:
//		Startup routine and main loop
//-------------------------------------------------------------------------------------------------------
int main (void) {
  UINT16 j;
  char *P5 = 0x31;


  WDTCTL = WDTPW + WDTHOLD; // Stop the Watch Dog Timer
  P5DIR |= BM(YLED)| BM(BLED)| BM(RLED);
  P5OUT = BM(YLED)+ BM(BLED)+ BM(RLED);

  // The main loop:
  while (TRUE) {

      for (j = 0; j<50000; j++) {
      	nop();
			}
//      TOGGLE_RLED();
	*P5 ^= 0x10;		

			for (j = 0; j<50000; j++) {
      	nop();
			}
//      TOGGLE_YLED();
      
      for (j = 0; j<50000; j++) {
      	nop();
			}
      TOGGLE_BLED();
	}   
} // main

















//  char *P5 = 0x31;
//	*P5 ^= 0x10;		
